<?php
/* --------------------------------------------------------------
 FileCacheFactory.php 2020-04-29
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Cache;

use Gambio\Core\Filesystem\Interfaces\Filesystem;
use Psr\EventDispatcher\EventDispatcherInterface;
use Psr\SimpleCache\CacheInterface;

/**
 * Class FileCacheFactory
 *
 * @package Gambio\Core\Cache
 * @codeCoverageIgnore
 */
class FileCacheFactory implements CacheFactory
{
    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;
    
    /**
     * @var Filesystem
     */
    private $filesystem;
    
    
    /**
     * CacheFactory constructor.
     *
     * @param EventDispatcherInterface $eventDispatcher
     * @param Filesystem               $filesystem
     */
    public function __construct(EventDispatcherInterface $eventDispatcher, Filesystem $filesystem)
    {
        $this->eventDispatcher = $eventDispatcher;
        $this->filesystem      = $filesystem;
    }
    
    
    /**
     * @inheritDoc
     */
    public function createCacheFor(string $namespace): CacheInterface
    {
        return FileCache::create($this->eventDispatcher, $this->filesystem, $namespace);
    }
}